/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.ae2;

import appeng.api.parts.IPartItem;
import appeng.parts.p2p.P2PTunnelPart;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class MultipleCapabilityP2PTunnelPart<P extends MultipleCapabilityP2PTunnelPart<P>>
extends P2PTunnelPart<P> {
    private final Map<Capability<?>, CapabilitySetInner<?, P>> capabilities;
    int accessDepth = 0;
    private boolean inBlockUpdate = false;

    public MultipleCapabilityP2PTunnelPart(IPartItem<?> partItem, Function<P, Collection<CapabilitySet<?>>> capabilities) {
        super(partItem);
        this.capabilities = capabilities.apply((P)((Object)this)).stream().collect(Collectors.toMap(CapabilitySet::capability, set -> set.toInner(this)));
    }

    protected float getPowerDrainPerTick() {
        return 2.0f;
    }

    public final <T> LazyOptional<T> getCapability(Capability<T> capability) {
        CapabilitySetInner<?, P> set = this.capabilities.get(capability);
        if (set != null) {
            if (this.isOutput()) {
                return LazyOptional.of(set::outputHandler).cast();
            }
            return LazyOptional.of(set::inputHandler).cast();
        }
        return LazyOptional.empty();
    }

    protected final <C> CapabilityGuard<C, P> getAdjacentCapability(Capability<C> capability) {
        ++this.accessDepth;
        return this.capabilities.get(capability).guard();
    }

    protected final <C> CapabilityGuard<C, P> getInputCapability(Capability<C> capability) {
        MultipleCapabilityP2PTunnelPart input = (MultipleCapabilityP2PTunnelPart)this.getInput();
        return input == null ? this.capabilities.get(capability).empty() : input.getAdjacentCapability(capability);
    }

    BlockPos getFacingPos() {
        return this.getHost().getLocation().getPos().m_142300_(this.getSide());
    }

    protected void sendBlockUpdate() {
        if (!this.inBlockUpdate) {
            this.inBlockUpdate = true;
            try {
                BlockEntity self = this.getBlockEntity();
                self.m_58904_().m_46672_(self.m_58899_(), Blocks.f_50016_);
            }
            finally {
                this.inBlockUpdate = false;
            }
        }
    }

    public void onTunnelNetworkChange() {
        this.sendBlockUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNeighborChanged(BlockGetter level, BlockPos pos, BlockPos neighbor) {
        if (!this.getFacingPos().equals((Object)neighbor)) {
            return;
        }
        if (!this.inBlockUpdate) {
            this.inBlockUpdate = true;
            try {
                if (this.isOutput()) {
                    MultipleCapabilityP2PTunnelPart input = (MultipleCapabilityP2PTunnelPart)this.getInput();
                    if (input != null) {
                        input.sendBlockUpdate();
                    }
                } else {
                    for (MultipleCapabilityP2PTunnelPart output : this.getOutputs()) {
                        output.sendBlockUpdate();
                    }
                }
            }
            finally {
                this.inBlockUpdate = false;
            }
        }
    }

    private record CapabilitySetInner<C, P extends MultipleCapabilityP2PTunnelPart<P>>(CapabilityGuard<C, P> guard, CapabilityGuard<C, P> empty, C inputHandler, C outputHandler) {
    }

    protected static class CapabilityGuard<C, P extends MultipleCapabilityP2PTunnelPart<P>>
    implements AutoCloseable {
        protected final C emptyHandler;
        private final P part;
        private final Capability<C> capability;

        public CapabilityGuard(P part, Capability<C> capability, C emptyHandler) {
            this.part = part;
            this.capability = capability;
            this.emptyHandler = emptyHandler;
        }

        public C get() {
            if (((MultipleCapabilityP2PTunnelPart)((Object)this.part)).accessDepth == 0) {
                throw new IllegalStateException("get was called after closing the wrapper");
            }
            if (((MultipleCapabilityP2PTunnelPart)((Object)this.part)).accessDepth == 1) {
                BlockEntity self;
                BlockEntity te;
                if (this.part.isActive() && (te = (self = this.part.getBlockEntity()).m_58904_().m_7702_(((MultipleCapabilityP2PTunnelPart)((Object)this.part)).getFacingPos())) != null) {
                    return (C)te.getCapability(this.capability, this.part.getSide().m_122424_()).orElse(this.emptyHandler);
                }
                return this.emptyHandler;
            }
            return this.emptyHandler;
        }

        @Override
        public void close() {
            if (--((MultipleCapabilityP2PTunnelPart)((Object)this.part)).accessDepth < 0) {
                throw new IllegalStateException("Close has been called multiple times");
            }
        }
    }

    public record CapabilitySet<C>(Capability<C> capability, C inputHandler, C outputHandler, C emptyHandler) {
        private <P extends MultipleCapabilityP2PTunnelPart<P>> CapabilitySetInner<C, P> toInner(P part) {
            return new CapabilitySetInner<C, P>(new CapabilityGuard<C, P>(part, this.capability(), this.emptyHandler()), new EmptyCapabilityGuard<C, P>(part, this.capability(), this.emptyHandler()), this.inputHandler(), this.outputHandler());
        }
    }

    private static class EmptyCapabilityGuard<C, P extends MultipleCapabilityP2PTunnelPart<P>>
    extends CapabilityGuard<C, P>
    implements AutoCloseable {
        public EmptyCapabilityGuard(P part, Capability<C> capability, C emptyHandler) {
            super(part, capability, emptyHandler);
        }

        @Override
        public void close() {
        }

        @Override
        public C get() {
            return (C)this.emptyHandler;
        }
    }
}

